async function loadPart(id, url) {
  const el = document.getElementById(id);
  if (!el) return;
  const res = await fetch(url, { cache: "no-cache" });
  el.innerHTML = await res.text();
}

function setActiveNav() {
  const path = location.pathname.split("/").pop() || "index.html";
  document.querySelectorAll("[data-nav]").forEach(a => {
    const href = a.getAttribute("href") || "";
    const current = href.split("/").pop();
    if (current === path) a.classList.add("active");
  });
}

function setActiveBottomNav() {
  const current = (location.pathname.split("/").pop() || "index.html").split("#")[0];
  document.querySelectorAll("[data-bnav]").forEach(a => {
    const hrefFile = (a.getAttribute("href") || "").split("/").pop().split("#")[0];
    const isExamSection = (hrefFile === "exams.html");
    const onExamPages = current.startsWith("exam-") || current === "exams.html";
    if (hrefFile === current || (isExamSection && onExamPages)) a.classList.add("active");
  });
}

function setActiveSidebarNav() {
  const current = (location.pathname.split("/").pop() || "index.html").split("#")[0];
  document.querySelectorAll("[data-snav]").forEach(a => {
    const hrefFile = (a.getAttribute("href") || "").split("/").pop().split("#")[0];
    const isExamSection = (hrefFile === "exams.html");
    const onExamPages = current.startsWith("exam-") || current === "exams.html";
    if (hrefFile === current || (isExamSection && onExamPages)) a.classList.add("active");
  });
}

function applyPageHeaderConfig() {
  const titleEl = document.getElementById("phTitle");
  const crumbEl = document.getElementById("phCrumb");
  const actionsEl = document.getElementById("phActions");
  if (!titleEl || !crumbEl || !actionsEl) return;

  const body = document.body;
  const title = body.getAttribute("data-page-title") || "ENABLED Tutors";
  const crumb = body.getAttribute("data-page-crumb") || "ENABLED Tutors • App";

  titleEl.textContent = title;
  crumbEl.textContent = crumb;

  const actions = body.getAttribute("data-page-actions") || "";
  if (actions.trim()) {
    const items = actions.split(";").map(x => x.trim()).filter(Boolean);
    actionsEl.innerHTML = "";
    items.forEach(item => {
      const parts = item.split("|").map(s => (s || "").trim());
      if (parts.length < 2) return;
      const [label, href] = parts;
      const a = document.createElement("a");
      a.className = "chip";
      a.href = href;
      a.textContent = label;
      actionsEl.appendChild(a);
    });
  }
}

function setupHeaderSearch() {
  const input = document.getElementById("phSearchInput");
  const clearBtn = document.getElementById("phSearchClear");
  const box = document.getElementById("phSearchResults");
  if (!input || !clearBtn || !box) return;

  const SEARCH_ITEMS = [
    { title: "Academic Subject Mastery", type: "Service", href: "/pages/services.html" },
    { title: "Coding and Programming Tutoring", type: "Service", href: "/pages/services.html" },
    { title: "Project / Assignment / Research Support", type: "Service", href: "/pages/services.html" },
    { title: "Examination Preparation Support", type: "Service", href: "/pages/services.html" },
    { title: "Educational Consultancy", type: "Service", href: "/pages/services.html" },

    { title: "Exams Hub", type: "Exams", href: "/pages/exams.html" },
    { title: "11+ Mastery Hub", type: "Exam", href: "/pages/exam-11plus.html" },
    { title: "WAEC/WASSCE Success Track", type: "Exam", href: "/pages/exam-waec.html" },
    { title: "GCSE Prep Hub", type: "Exam", href: "/pages/exam-gcse.html" },
    { title: "SAT Prep Hub", type: "Exam", href: "/pages/exam-sat.html" },

    { title: "Pricing Plans", type: "Page", href: "/pages/pricing.html" },
    { title: "Book Free Consultation", type: "Page", href: "/pages/contact.html#consultation" },

    { title: "Login", type: "Auth", href: "/auth/login.html" },
    { title: "Create Account", type: "Auth", href: "/auth/register.html" },
    { title: "Student Portal", type: "Portal", href: "/portal/student/index.html" },
    { title: "Tutor Portal", type: "Portal", href: "/portal/tutor/index.html" }
  ];

  function renderResults(list) {
    if (!list.length) {
      box.innerHTML = `<div class="px-3 py-3 small text-muted">No results found.</div>`;
      box.classList.remove("d-none");
      return;
    }
    box.innerHTML = list.map(item => `
      <a class="item" href="${item.href}">
        <span>${item.title}</span>
        <small>${item.type}</small>
      </a>
    `).join("");
    box.classList.remove("d-none");
  }

  function hideResults() {
    box.classList.add("d-none");
    box.innerHTML = "";
  }

  function doSearch() {
    const q = input.value.trim().toLowerCase();
    if (!q) { hideResults(); return; }
    const matches = SEARCH_ITEMS
      .filter(x => x.title.toLowerCase().includes(q) || x.type.toLowerCase().includes(q))
      .slice(0, 8);
    renderResults(matches);
  }

  input.addEventListener("input", doSearch);
  input.addEventListener("focus", doSearch);

  clearBtn.addEventListener("click", () => {
    input.value = "";
    input.focus();
    hideResults();
  });

  document.addEventListener("click", (e) => {
    const inside = e.target.closest(".ph-search");
    if (!inside) hideResults();
  });
}

(async function initLayout(){
  await loadPart("appHeader", "/components/header.html");
  await loadPart("appFooter", "/components/footer.html");
  await loadPart("pageHeader", "/components/page-header.html");

  setActiveNav();
  setActiveBottomNav();
  setActiveSidebarNav();
  applyPageHeaderConfig();
  setupHeaderSearch();

  const y = document.getElementById("year");
  if (y) y.textContent = new Date().getFullYear();
})();
