from django.contrib import admin
from django.urls import path, include, re_path
from django.conf import settings
from django.conf.urls.static import static
from django.views.generic import RedirectView, TemplateView
from django.http import HttpResponse
import json


# -----------------------------------------------------------------------------
# PWA helper endpoints (avoid 404s for manifest/offline in dev & prod)
# -----------------------------------------------------------------------------
def manifest_json(request):
    data = {
        "name": "ENABLED Tutors",
        "short_name": "ENABLED",
        "start_url": "/",
        "scope": "/",
        "display": "standalone",
        "background_color": "#ffffff",
        "theme_color": "#0ea5e9",
        "icons": [
            {"src": "/static/icons/icon-192.png", "sizes": "192x192", "type": "image/png"},
            {"src": "/static/icons/icon-512.png", "sizes": "512x512", "type": "image/png"},
            {"src": "/static/icons/maskable-512.png", "sizes": "512x512", "type": "image/png", "purpose": "maskable"},
        ],
    }
    return HttpResponse(json.dumps(data), content_type="application/manifest+json")

urlpatterns = [
    
    path('chat/', include('chat.urls')),
path("admin/", admin.site.urls),

    # PWA endpoints (avoid noisy 404s)
    path("manifest.json", manifest_json, name="manifest"),
    path("offline.html", TemplateView.as_view(template_name="offline.html"), name="offline"),
    re_path(r"^index\.html$", RedirectView.as_view(url="/", permanent=False)),

    # -------------------------------------------------------------------------
    # Legacy URL compatibility (for users typing template filenames in the URL)
    # Keeps UI the same; just redirects old .html paths to the real routes.
    # -------------------------------------------------------------------------
    re_path(r"^auth/login\.html$", RedirectView.as_view(url="/auth/login/", permanent=False)),
    re_path(r"^auth/register\.html$", RedirectView.as_view(url="/auth/register/", permanent=False)),
    re_path(r"^auth/logout\.html$", RedirectView.as_view(url="/auth/logout/", permanent=False)),

    re_path(r"^portal/student/index\.html$", RedirectView.as_view(url="/portal/student/", permanent=False)),
    re_path(r"^portal/tutor/index\.html$", RedirectView.as_view(url="/portal/tutor/", permanent=False)),

    re_path(r"^pages/services\.html$", RedirectView.as_view(url="/services/", permanent=False)),
    re_path(r"^pages/exams\.html$", RedirectView.as_view(url="/exams/", permanent=False)),
    re_path(r"^pages/pricing\.html$", RedirectView.as_view(url="/pricing/", permanent=False)),
    re_path(r"^pages/about\.html$", RedirectView.as_view(url="/about/", permanent=False)),
    re_path(r"^pages/contact\.html$", RedirectView.as_view(url="/contact/", permanent=False)),

    # Some browsers/bookmarks may include a trailing slash.
    re_path(r"^auth/login\.html/$", RedirectView.as_view(url="/auth/login/", permanent=False)),
    re_path(r"^auth/register\.html/$", RedirectView.as_view(url="/auth/register/", permanent=False)),
    re_path(r"^portal/student/index\.html/$", RedirectView.as_view(url="/portal/student/", permanent=False)),
    re_path(r"^portal/tutor/index\.html/$", RedirectView.as_view(url="/portal/tutor/", permanent=False)),
    re_path(r"^pages/(?P<name>[A-Za-z0-9_-]+)\.html/$", RedirectView.as_view(url="/", permanent=False)),

    # Normal app routes
    path("", include("pages.urls")),
    path("auth/", include("accounts.urls")),
    path("portal/", include("portal.urls")),
    path("api/", include("bookings.api_urls")),
    path("api/chat/", include("chat.api_urls")),
]

# Serve media in dev. (In production, configure your web server to serve /media/.)
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)