from rest_framework import serializers
from .models import Booking

class BookingSerializer(serializers.ModelSerializer):
    class Meta:
        model = Booking
        fields = [
            "id","student","tutor","service","subject","exam","level","description",
            "preferred_date","preferred_time","timezone","status","tutor_response_note","tutor_responded_at","created_at","updated_at"
        ]
        read_only_fields = ["id","student","status","created_at","updated_at"]

class BookingCreateSerializer(serializers.ModelSerializer):
    class Meta:
        model = Booking
        fields = [
            "service","subject","exam","level","description","preferred_date","preferred_time","timezone"
        ]
