from django.conf import settings
from django.db import models

class Booking(models.Model):
    STATUS_NEW = "new"
    STATUS_ASSIGNED = "assigned"
    STATUS_TUTOR_ACCEPTED = "tutor_accepted"
    STATUS_TUTOR_DECLINED = "tutor_declined"
    STATUS_CONFIRMED = "confirmed"
    STATUS_COMPLETED = "completed"
    STATUS_CANCELLED = "cancelled"
    STATUS_CHOICES = [
        (STATUS_NEW, "New"),
        (STATUS_ASSIGNED, "Assigned"),
        (STATUS_TUTOR_ACCEPTED, "Tutor Accepted"),
        (STATUS_TUTOR_DECLINED, "Tutor Declined"),
        (STATUS_CONFIRMED, "Confirmed"),
        (STATUS_COMPLETED, "Completed"),
        (STATUS_CANCELLED, "Cancelled"),
    ]

    student = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE, related_name="student_bookings")
    tutor = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.SET_NULL, null=True, blank=True, related_name="tutor_bookings")

    service = models.CharField(max_length=120)  # e.g Academic, Coding, Exams, Project Support
    subject = models.CharField(max_length=120, blank=True)
    exam = models.CharField(max_length=120, blank=True)  # e.g IELTS, WAEC, SAT
    level = models.CharField(max_length=120, blank=True)  # e.g Secondary, University

    description = models.TextField(blank=True)

    preferred_date = models.DateField(null=True, blank=True)
    preferred_time = models.CharField(max_length=40, blank=True)
    timezone = models.CharField(max_length=60, blank=True)

    status = models.CharField(max_length=20, choices=STATUS_CHOICES, default=STATUS_NEW)
    tutor_response_note = models.CharField(max_length=255, blank=True)
    tutor_responded_at = models.DateTimeField(null=True, blank=True)

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return f"Booking #{self.id} - {self.service} - {self.student}"
