from django.contrib.auth.models import AbstractUser
from django.db import models

class User(AbstractUser):
    ROLE_STUDENT = "student"
    ROLE_TUTOR = "tutor"
    ROLE_CHOICES = [
        (ROLE_STUDENT, "Student"),
        (ROLE_TUTOR, "Tutor"),
    ]

    email = models.EmailField(unique=True)
    role = models.CharField(max_length=20, choices=ROLE_CHOICES, default=ROLE_STUDENT)

    # Optional tutor profile fields
    bio = models.TextField(blank=True)
    subjects = models.CharField(max_length=255, blank=True, help_text="Comma-separated subjects you can teach")
    exams = models.CharField(max_length=255, blank=True, help_text="Comma-separated exams you can support (e.g. IELTS, WAEC)")
    services = models.CharField(max_length=255, blank=True, help_text="Comma-separated services (e.g Academic, Coding, Exams)")

    def __str__(self) -> str:
        return f"{self.get_full_name() or self.username} ({self.email})"
