# ENABLED Tutors — Django + Frontend App

This build converts your UI into a real Django application with:
- ✅ Real authentication (Student/Tutor roles)
- ✅ Booking API (Django REST Framework)
- ✅ Student & Tutor portals wired to the database
- ✅ Your existing HTML/Bootstrap/Tailwind UI kept

## Quick start (Local)

```bash
cd enabled-tutors-django/src
python -m venv .venv
# Windows: .venv\Scripts\activate
source .venv/bin/activate

pip install -r ../requirements.txt
python manage.py migrate
python manage.py createsuperuser
python manage.py runserver
```

Open:
- Home: http://127.0.0.1:8000/
- Login: http://127.0.0.1:8000/auth/login/
- Register: http://127.0.0.1:8000/auth/register/
- Student Portal: http://127.0.0.1:8000/portal/student/
- Tutor Portal: http://127.0.0.1:8000/portal/tutor/
- Admin: http://127.0.0.1:8000/admin/

## Booking flow (real)

Use:
- New Booking UI: `/portal/student/new-booking/` → confirm → submits to `/api/bookings/`
- Student bookings list: `/portal/student/bookings/`

## API
- `GET /api/bookings/` (your bookings)
- `POST /api/bookings/` (create booking)
- `GET /api/bookings/my/` (student + tutor arrays)

## Assign bookings to tutors
1. Create tutors in `/admin/` (Users role = tutor)
2. Create/inspect bookings in `/admin/` and set the tutor field.


## Environment files

- Local dev uses `.env.local` (SQLite).
- Hosting uses `.env.production` (MySQL).

How it loads:
1. `.env` (shared)
2. `.env.local` or `.env.production` depending on `DJANGO_ENV`
3. You can force a file via `ENV_FILE`.

Examples:
- Local: `set DJANGO_ENV=local` then run server.
- Production: set `DJANGO_ENV=production`.


## Production deploy (enable.payslashes.com)

1) Upload this project to hosting.
2) Put your real secrets in `.env.production`:
   - `SECRET_KEY`
   - `DB_PASSWORD`
   - `EMAIL_HOST_PASSWORD` (Gmail App Password)
3) Ensure your hosting environment has:
   - `DJANGO_ENV=production`
4) Install requirements, then run:

```bash
python manage.py migrate
python manage.py collectstatic --noinput
python manage.py healthcheck
```

To send a real test email:

```bash
python manage.py healthcheck --send-email --email-to enabled1000@gmail.com
```

MySQL hardening:
- utf8mb4 enabled via `DATABASES['default']['OPTIONS']['charset']='utf8mb4'`
- pooling via `DB_CONN_MAX_AGE=60` (adjust in `.env.production`)

## Local development (SQLite)

1) Ensure you have Python 3.11+ and install deps:

```bash
pip install -r requirements.txt
```

2) Use the included `.env.local` (or copy `.env.example` to `.env.local`).

3) Run migrations and start server:

```bash
python manage.py migrate
python manage.py runserver
```

Optional: If you want to test MySQL locally, set `DB_ENGINE=mysql` and your MySQL creds in `.env.local`.
The app can auto-fallback to SQLite if MySQL fails (controlled by `DB_FALLBACK=1`).


## Consultation Form Email
Set these env vars (Gmail recommended via App Password):

- EMAIL_HOST=smtp.gmail.com
- EMAIL_PORT=587
- EMAIL_USE_TLS=1
- EMAIL_HOST_USER=your@gmail.com
- EMAIL_HOST_PASSWORD=your_app_password
- DEFAULT_FROM_EMAIL=your@gmail.com
- CONSULTATION_NOTIFY_EMAIL=where_to_receive@yourmail.com (optional)

Local dev: set EMAIL_BACKEND=django.core.mail.backends.console.EmailBackend to print emails in terminal.
